# Modular arbitrary-order ocean-atmosphere model: MAOOAM -- Stochastic Fortran implementation #

## About ##

(c) 2013-2017 Lesley De Cruz and Jonathan Demaeyer

See [LICENSE.txt](LICENSE.txt) for license information.

This software is provided as supplementary material with:

* De Cruz, L., Demaeyer, J. and Vannitsem, S.: The Modular Arbitrary-Order
Ocean-Atmosphere Model: MAOOAM v1.0, Geosci. Model Dev., 9, 2793-2808,
[doi:10.5194/gmd-9-2793-2016](http://dx.doi.org/10.5194/gmd-9-2793-2016), 2016.

for the MAOOAM original code, and with

*

for the stochastic part.

**Please cite both articles if you use (a part of) this software for a
publication.**

The authors would appreciate it if you could also send a reprint of
your paper to <lesley.decruz@meteo.be>, <jonathan.demaeyer@meteo.be> and
<svn@meteo.be>. 

Consult the MAOOAM [code repository](http://www.github.com/Climdyn/MAOOAM)
for updates, and [our website](http://climdyn.meteo.be) for additional
resources.

------------------------------------------------------------------------

## Branch description ##

This branch is a version of the MAOOAM model focused on stochastic methods
and more particularly stochastic parameterizations. 

------------------------------------------------------------------------

## Parameterizations description ##

For the moment, this code provide the implementation of two different
stochastic parameterizations for the MAOOAM ocean-atmosphere coupled
model.

The first one is based on homogenization and follow closely the 
approach proposed in Franzke et al. 2005. It is called hereafter "MTV", from the
names of the authors of the paper that first proposed to apply the method 
to climate systems (Majda et al., 2001).

The second one is based on the Ruelle response theory, and is called
hereafter "WL", from the names of the authors of the paper that proposed
to apply response theory to parameterization problems (Wouters and Lucarini, 2012).

------------------------------------------------------------------------

## Installation ##

The program can be installed with Makefile. We provide configuration files for 
two compilers : gfortran and ifort.

By default, gfortran is selected. To select one or the other, simply modify the 
Makefile accordingly. If gfortran is selected, the code should be compiled 
with gfortran 4.7+ (allows for allocatable arrays in namelists). 
If ifort is selected, the code has been tested with the version 14.0.2 and we 
do not guarantee compatibility with older compiler version.

To install, unpack the archive in a folder, and run:
     make
 
 Remark: The command "make clean" removes the compiled files.

------------------------------------------------------------------------

##  Description of the files ##

The model tendencies are represented through a tensor called aotensor which
includes all the coefficients. This tensor is computed once at the program
initialization.

The following files are part of the MAOOAM model alone:

* maooam.f90 : Main program.
* aotensor_def.f90 : Tensor aotensor computation module.
* IC_def.f90 : A module which loads the user specified initial condition.
* inprod_analytic.f90 : Inner products computation module.
* rk2_integrator.f90 : A module which contains the Heun integrator for the model equations.
* rk4_integrator.f90 : A module which contains the RK4 integrator for the model equations.
* Makefile : The Makefile.
* gfortran.mk : Gfortran compiler options file.
* ifort.mk : Ifort compiler options file.
* params.f90 : The model parameters module.
* tl_ad_tensor.f90 : Tangent Linear (TL) and Adjoint (AD) model tensors definition module
* rk2_tl_ad_integrator.f90 : Heun Tangent Linear (TL) and Adjoint (AD) model integrators module
* rk4_tl_ad_integrator.f90 : RK4 Tangent Linear (TL) and Adjoint (AD) model integrators module
* test_tl_ad.f90 : Tests for the Tangent Linear (TL) and Adjoint (AD) model versions
* README.md : The present file.
* LICENSE.txt : The license text of the program.
* util.f90 : A module with various useful functions.
* tensor.f90 : Tensor utility module.
* stat.f90 : A module for statistic accumulation.
* params.nml : A namelist to specify the model parameters.
* int_params.nml : A namelist to specify the integration parameters.
* modeselection.nml : A namelist to specify which spectral decomposition will be used.

with the addition of the files:

* maooam_stoch.f90 : Stochastic implementation of MAOOAM.
* maooam_MTV.f90 : Main program - MTV implementation for MAOOAM. 
* maooam_WL.f90 : Main program - WL implementation for MAOOAM. 
* corrmod.f90 : Unresolved variables correlation matrix initialization module.
* corr_tensor.f90 : Correlations and derivatives for the memory term of the WL parameterization.
* dec_tensor.f90 : Tensor resolved-unresolved components decomposition module.
* int_comp.f90 : Utility module containing the routines to perform the integration of functions.
* int_corr.f90 : Module to compute or load the integrals of the correlation matrices.
* MAR.f90 : Multidimensional AutoRegressive (MAR) module to generate the correlation for the WL parameterization.
* memory.f90 : WL parameterization memory term \f$M_3\f$ computation module. 
* MTV_int_tensor.f90 : MTV tensors computation module.
* MTV_sigma_tensor.f90 : MTV noise sigma matrices computation module.
* WL_tensor.f90 : WL tensors computation module.
* rk2_stoch_integrator.f90 : Stochastic RK2 integration routines module.
* rk2_ss_integrator.f90 : Stochastic uncoupled resolved nonlinear and tangent linear RK2 dynamics integration module.
* rk2_MTV_integrator.f90 :  MTV RK2 integration routines module.
* rk2_WL_integrator.f90 :  WL RK2 integration routines module.
* sf_def.f90 : Module to select the resolved-unresolved components.
* SF.nml : A namelist to select the resolved-unresolved components.
* sqrt_mod.f90 : Utility module with various routine to compute matrix square root.
* stoch_mod.f90 : Utility module containing the stochastic related routines.
* stoch_params.f90 : Stochastic models parameters module.
* stoch_params.nml : A namelist to specify the stochastic models parameters.

which belong specifically to the stoch branch.

A documentation is available [here](./doc/html/index.html) (html) and [here](./doc/latex/Reference_manual.pdf) (pdf).
 
------------------------------------------------------------------------

## MAOOAM Usage ##

The user first has to fill the params.nml and int_params.nml namelist files according to their needs.
Indeed, model and integration parameters can be specified respectively in the params.nml and int_params.nml namelist files. Some examples related to already published article are available in the params folder.

The modeselection.nml namelist can then be filled : 
* NBOC and NBATM specify the number of blocks that will be used in respectively the ocean and
  the atmosphere. Each block corresponds to a given x and y wavenumber.
* The OMS and AMS arrays are integer arrays which specify which wavenumbers of
  the spectral decomposition will be used in respectively the ocean and the
  atmosphere. Their shapes are OMS(NBOC,2) and AMS(NBATM,2).
* The first dimension specifies the number attributed by the user to the block and the second
  dimension specifies the x and the y wavenumbers.
* The VDDG model, described in Vannitsem et al. (2015) is given as an example
  in the archive.
* Note that the variables of the model are numbered according to the chosen
  order of the blocks.


Finally, the IC.nml file specifying the initial condition should be defined. To
obtain an example of this configuration file corresponding to the model you
have previously defined, simply delete the current IC.nml file (if it exists)
and run the program :

    ./maooam

It will generate a new one and start with the 0 initial condition. If you want another 
initial condition, stop the program, fill the newly generated file and restart :

    ./maooam

It will generate two files :
 * evol_field.dat : the recorded time evolution of the variables.
 * mean_field.dat : the mean field (the climatology)

------------------------------------------------------------------------

## Stochastic code usage ##

The user first has to fill the MAOOAM model namelist files according to the previous section. 
Additional namelist files for the fine tuning of the parameterization must then be filled,
and some "definition" files (with the extension .def) must be provided. An example is provided with the code.

Full details over the parameterization options and definition files can be found in the documentation: ([html](./dec/html/index.html))
 and ([pdf](./doc/latex/Reference_manual.pdf)).

The program "maooam_stoch" will generate the evolution of the full stochastic dynamics with the command:

    ./maooam_stoch

or any other dynamics if specified as an argument (see the header of [maooam_stoch.f90](./maooam_stoch.f90)).
It will generate two files :
 * evol_field.dat : the recorded time evolution of the variables.
 * mean_field.dat : the mean field (the climatology)

The program "maooam_MTV" will generate the evolution of the MTV parameterization evolution, with the command:

    ./maooam_MTV

It will generate three files :
 * evol_MTV.dat : the recorded time evolution of the variables.
 * ptend_MTV.dat : the recorded time evolution of the tendencies (used for debugging).
 * mean_field_MTV.dat : the mean field (the climatology)

The program "maooam_WL" will generate the evolution of the MTV parameterization evolution, with the command:

    ./maooam_WL

It will generate three files :
 * evol_WL.dat : the recorded time evolution of the variables.
 * ptend_WL.dat : the recorded time evolution of the tendencies (used for debugging).
 * mean_field_WL.dat : the mean field (the climatology)

------------------------------------------------------------------------

## Implementation notes ##

A stochastic version of MAOOAM and two stochastic parameterization methods
(MTV and WL) are provided with this code.

They are detailed [here](./doc/html/md_para_doc.html).

------------------------------------------------------------------------

## Final Remarks ##

  No animals were harmed during the coding process.
