#include <map>
#include <set>
                                                                                
#include <blitz/array.h>                                                        
#include <gnuplot-iostream.h>  

#include "../common/hdf5.hpp"

int main()
{
  std::array<std::string, 4> ixs{"id","ln","p2","p3"};

  // simulations                                                                
  std::map<double, std::map<std::string, std::map<double, H5::H5File>>> cases;

  for (auto &mlt_t : std::list<double>{1.,2.,500})
  {
    for (auto &ix : ixs)                                                      
    {                                                                         
      for (auto &mlt_tol : std::set<double>{                                  
	pow(5, 1),                                                            
	pow(5, 0),                                                            
	pow(5,-1),                                                            
	pow(5,-2),                                                            
	pow(5,-3),                                                            
      }) {        
	std::ostringstream fname;
	fname << "refcase_reltol_x_" << mlt_tol << "_ix=" << ix << "_t_mlt_" << mlt_t << ".nc";
	{                                                                     
	  std::string cmd = "cp ../common/refcase.nc " + fname.str();         
	  system(cmd.c_str());                                                
	}
	std::ostringstream label;
	double w;
	{                                                                     
	  H5::H5File file(fname.str().c_str(), H5F_ACC_RDWR);                 
	  h5_setpar(file, "reltol", mlt_tol * h5_getpar(file, "reltol"));     
	  h5_setpar(file, "t_hlf", mlt_t * h5_getpar(file, "t_hlf"));         
	  w = h5_getpar(file, "z_hlf") / h5_getpar(file, "t_hlf");            
	}                                                                     
	{                                                                     
	  std::string cmd = "../../main " + fname.str() + " " + ix;           
	  system(cmd.c_str());                                                
	}                                                                     
	cases[w][ix][mlt_tol] = H5::H5File(fname.str().c_str(), H5F_ACC_RDONLY);
      }
    }
  }
  
  // plot
  std::map<std::string, std::string> tts{{"id","r"},{"ln","ln(r/1nm)"},{"p2","r^2"},{"p3","r^3"}};

  Gnuplot gp;
  gp << "set term svg dynamic\n";
  gp << "set output 'consrv.svg'\n";
  gp << "set xlabel 'log_{10}(relative tolerance) [1]'\n";
  gp << "set ylabel 'log_{10}(max(|(r_t - r_t|_0) / r_t|_0|)) [1]'\n";
  gp << "set grid\n";
  gp << "set key left\n";
  gp << "plot 1./0 not";
  double lw = 4;
  for (auto &cs_w : cases)
  {
    int lt = 1;
    auto &w = cs_w.first;
    for (auto &cs_ix : cs_w.second)
    {
      gp << ",'-' with lines lw " << lw << " lt " << lt << " title '" << (w==1.?tts[cs_ix.first]:"") << "'";
      lt++;
    }
    lw--;
  }
  gp << "\n";

  for (auto &cs_w : cases)
  {
    for (auto &cs_ix : cs_w.second)
    {
      int i=0;
      std::array<blitz::Array<double,1>,2> data;
      for (auto &arr : data) arr.resize(cs_ix.second.size());
      for (auto &cs_tol : cs_ix.second)
      {
	auto &h5 = cs_tol.second;
        auto rt = h5_getarr(h5, "rt");
        rt = (rt - rt(0))/rt(0);
        data[0](i) = log10(h5_getpar(h5,"reltol"));
        data[1](i) = log10(max(abs(rt)));
        i++;
      }
      gp.send(data);
    }
  }
}
