#include <set>
#include <map>

#include <blitz/array.h>                                                        
#include <gnuplot-iostream.h> 

#include "../common/hdf5.hpp"                                                   

int main()
{
  // simulations
  std::map<double, H5::H5File> cases;
std::list<int> aqq({0});
std::ofstream file("data.txt");
for (int i=1; i < 200; i++) aqq.push_back(i);
  for (auto &mode : aqq)
  {
    std::ostringstream fname;                                                 
    fname << "refcase_mode=" << mode << ".nc";
    {                                                                         
      std::string cmd = "cp ../common/refcase.nc " + fname.str();             
      system(cmd.c_str());                                                    
    }                                                                         
    {                                                                         
      H5::H5File file(fname.str().c_str(), H5F_ACC_RDWR);                     
      if (mode != 0) 
        h5_setpar(file, "freq", (mode+.5) / (2.*h5_getpar(file, "t_hlf")));
      h5_setpar(file, "ampl", .075);

      h5_setpar(file, "rd2", h5_getpar(file, "rd1")/2.3);
      h5_setpar(file, "kpa2", h5_getpar(file, "kpa1"));
      h5_setpar(file, "N2_stp", h5_getpar(file, "N1_stp"));
    }                                                                         
    {                                                                         
      std::string cmd = "../../main " + fname.str();                          
      system(cmd.c_str());                                                    
    }                                                                         
    cases[mode] = H5::H5File(fname.str().c_str(), H5F_ACC_RDONLY);  
file << h5_getpar(cases[mode], "freq") << "\t" << max(h5_getarr(cases[mode], "rw2")) << std::endl;
  }
exit(1);

  // plotting
  Gnuplot gp;
  gp << "set terminal svg dynamic\n";
  gp << "set output 'bidisp.svg'\n";
  gp << "set xlabel 'wet radius [µm]' offset 0,.5\n";
  gp << "set ylabel 'time [s]'\n";
  gp << "set logscale x\n";
  gp << "set xrange [.075:6]\n";
  gp << "set xtics 2\n";
  gp << "set yrange [0:300]\n";
  gp << "set key bottom sample .5\n";
  gp << "set multiplot\n";
  gp << "set origin 0,0\n";
  gp << "set size 2.05/3,1\n";
  gp << "plot 1./0 not";
  for (auto &cs : cases)
  {
    auto &mode = cs.first;
    auto &h5 = cs.second;                                                   
    auto 
      freq = h5_getpar(h5, "freq"),
      ampl = h5_getpar(h5, "ampl");
    std::ostringstream title;
    title << std::setprecision(3);
    if (freq == 0 || ampl == 0) title << "no fluctuations";
    else title << "f=" << freq << " Hz  A=" << ampl << " m";
    gp << ",'-' using (1e6*$1):2 with lines dt 2 lc rgb 'web-blue' title '" << (mode == 0 ? "critical radii":"") << "'";
    gp << ",'-' using (1e6*$1):2 with lines dt 2 lc rgb 'web-blue' notitle";
    gp << ",'-' using (1e6*$1):2 with lines lc rgb '" << (freq==0?"slategray":mode==60?"red":"black") << "' lw " << (freq==0?"5":mode==60?"1.8":".6") << " title '" << title.str() << "'";
    gp << ",'-' using (1e6*$1):2 with lines lc rgb '" << (freq==0?"slategray":mode==60?"red":"black") << "' lw " << (freq==0?"5":mode==60?"1.8":".6") << " notitle";
  }
  gp << "\n";

  std::array<blitz::Array<float, 1>, 2> data;                       

  for (auto &cs : cases)
  {
    auto &h5 = cs.second;                                                   
    data[1].reference(h5_getarr(h5, "t"));                                  

    data[0].reference(h5_getarr(h5, "rc1"));
    gp.send(data); 
    data[0].reference(h5_getarr(h5, "rc2"));                                  
    gp.send(data); 
    data[0].reference(h5_getarr(h5, "rw1"));                                 
    gp.send(data); 
    data[0].reference(h5_getarr(h5, "rw2"));                                  
    gp.send(data); 
  }

  gp << "set origin .66,0\n";
  gp << "set size 1./3,1\n";
  gp << "set xlabel 'S=RH-1 [%]'\n";
  gp << "set format y ''\n";
  gp << "set ylabel ''\n";
  gp << "set xrange [-.2:*]\n";
  gp << "set nologscale\n";
  gp << "set grid\n";
  gp << "set xtics .2\n";
  gp << "plot 1./0 not";
  for (auto &cs : cases)
  {
    auto &mode = cs.first;
    auto &h5 = cs.second;                                                   
    auto freq = h5_getpar(h5, "freq");
    gp << ",'-' using (($1-1)*100):2 with lines lc rgb '" << (freq==0?"slategray":mode==60?"red":"black") << "' lw " << (freq==0?"5":mode==60?"1.8":".6") << " notitle";
    gp << ",'-' using (($1-1)*100):2 with lines dt " << 2 << " lc rgb 'web-blue' title '" << (mode==0?"equil. S (bigger)":"") << "'";
    gp << ",'-' using (($1-1)*100):2 with lines dt " << 2 << " lc rgb 'dark-red' title '" << (mode==0?"(smaller particles)":"") << "'";
  }
  gp << "\n";
  for (auto &cs : cases)
  {
    auto &h5 = cs.second;                                                   
    data[1].reference(h5_getarr(h5, "t"));
    data[0].reference(h5_getarr(h5, "RH"));
    gp.send(data); 
    data[0].reference(h5_getarr(h5, "RHeq1"));
    gp.send(data); 
    data[0].reference(h5_getarr(h5, "RHeq2"));
    gp.send(data); 
  }
}
